# -*- coding: UTF-8 -*-

import os
import pickle

import torch


if __name__ == '__main__':
    x = torch.normal(0., 1., (4000, 10), dtype=torch.float)
    W = torch.tensor([-1] * 10, dtype=torch.float).diag()
    y = x @ W

    std = 1e-2
    noise = torch.normal(0., std, y.shape, dtype=torch.float)
    y = y + noise

    export_data = dict(x=x, y=y)

    save_path = "./data"
    if not os.path.exists(save_path):
        os.makedirs(save_path)

    with open(os.path.join(save_path, "data.pkl"), "wb") as f:
        pickle.dump(export_data, f)

